import cv2
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.image as mpimg
import os
import sys

def click_event(event, x, y, flags, param):
    """
    ## Function used to print on the image screen the x and y coordinates of left click mouse
    """
    if event == cv2.EVENT_LBUTTONDOWN:
        
        print('Coordinates-> x:', x,', y:' ,y)
        font = cv2.FONT_HERSHEY_SIMPLEX
        strXY = str(x) + ', '+ str(y)
        cv2.putText(image, strXY, (x, y), font, .5, (255, 10, 255), 1)
        cv2.circle(image, (x-3, y), 4, (255, 10 , 255), -1)
        cv2.imshow('Image', image)
    
    # Right click mouse is able to print on the image screen the BGR color values
    if event == cv2.EVENT_RBUTTONDOWN:
        blue = image[y, x, 0]
        green = image[y, x, 1]
        red = image[y, x, 2]
        print("BGR: ", '[' ,blue, ', ', green, ', ', red, ']')
        font = cv2.FONT_HERSHEY_COMPLEX
        strBGR = str(blue) + ', '+ str(green)+ ', '+ str(red)
        cv2.putText(image, strBGR, (x, y), font, .5, (10, 255, 255), 1)
        cv2.circle(image, (x-3, y), 4, (10, 255 , 255), -1)
        cv2.imshow('Image', image)

# Insert here the path file image to analyze
pathfile= 'Curve_line.jpg'
        
if pathfile.lower().endswith(('.png', '.jpg', '.jpeg', )):
    # NOTE: OpenCV uses BGR as its default colour order for representing images, matplotlib uses RGB color space instead
    image = cv2.imread(pathfile,cv2.IMREAD_UNCHANGED)
    if image is None:
        print("Unable to read file. Exiting...")
        sys.exit()

    # height, width, number of channels in image
    height = image.shape[0]
    width = image.shape[1]
    channels = image.shape[2]

    print('Image Height       : ',height)
    print('Image Width        : ',width)
    print('Number of Channels : ',channels)

    # Resizing the image
    print("Resizing the input image...")
    image = cv2.resize(image, dsize=(1280, 720))
    (H, W) = image.shape[:2]
    print('Shape of the resized image: W x H:', W, 'x', H)

    print("Showing the image...")
    cv2.namedWindow("Image", cv2.WINDOW_AUTOSIZE)
    cv2.imshow("Image",image)

    # callback function able to capture the mouse click coordinates on the image in order to set the ROI coordinates
    cv2.setMouseCallback('Image', click_event)
    
    cv2.waitKey(0)
    cv2.destroyAllWindows()
else:
    print("Unable to read file, format file not supported yet. Exiting...")
    sys.exit()